PROC GLOBAL

numeric numCasesPerFile = 50;

numeric currentCase,currentIteration,desiredStartCase,desiredEndCase;

file pffFile;

function writeOutPffAndStop(nextStartIteration)

	setfile(pffFile,maketext("%s%d%d_%d.pff",pathname(temp),sysdate("YYYYMMDD"),systime(),nextStartIteration));

	filewrite(pffFile,"[Run Information]");
	filewrite(pffFile,"Version=CSPro 4.1");
	filewrite(pffFile,"AppType=Batch");
	
	filewrite(pffFile,"[Files]");
	filewrite(pffFile,"Application=%ssplitFile.bch",pathname(application));
	filewrite(pffFile,"InputData=%s",filename(CEN2000));
	filewrite(pffFile,"OutputData=%s_%d",filename(CEN2000),nextStartIteration);
	filewrite(pffFile,"Listing=%s.lst",filename(pffFile));
	
	filewrite(pffFile,"[Parameters]");
	filewrite(pffFile,"ViewListing=Never");
	filewrite(pffFile,"ViewResults=Yes");
	filewrite(pffFile,"Parameter=%d",nextStartIteration);
	
	close(pffFile);
	
	execpff(filename(pffFile));
	stop();

end;


PROC DICTIONARY_FF

preproc

	if sysparm() = "" then // we're on the first run
		writeOutPffAndStop(1);

	else
		currentIteration = tonumber(sysparm());
		desiredStartCase = 1 + ( currentIteration - 1 ) * numCasesPerFile;
		desiredEndCase = desiredStartCase + numCasesPerFile - 1;

	endif;


PROC QUEST

preproc

	inc(currentCase);
	
	if currentCase > desiredEndCase then
		writeOutPffAndStop(currentIteration + 1);
	
	elseif currentCase < desiredStartCase then
		skip case;
	
	endif;
